#include "bits/stdc++.h"

using namespace std;
#define sz(x) (int)(x).size()
using lint = long long;
using pii = pair<int, int>;
using vi = vector<int>;

template<class T>
int sgn(T x) { return (x > 0) - (x < 0); }

template<class T>
struct PointT {
    using P = PointT;
    T x, y;
    explicit PointT(T x = 0, T y = 0) : x(x), y(y) {}
    bool operator==(P p) const { return tie(x, y) == tie(p.x, p.y); }
    bool operator<(const PointT &rhs) const { return tie(x, y) < tie(rhs.x, rhs.y); }
    P operator+(P p) const { return P(x + p.x, y + p.y); }
    P operator-(P p) const { return P(x - p.x, y - p.y); }
    P operator*(T d) const { return P(x * d, y * d); }
    P operator/(T d) const { return P(x / d, y / d); }
    T dot(P p) const { return x * p.x + y * p.y; }
    T cross(P p) const { return x * p.y - y * p.x; }
    T cross(P a, P b) const { return (a - *this).cross(b - *this); }
    T dist2() const { return x * x + y * y; }

    friend std::istream &operator>>(std::istream &is, P &p) {
        return is >> p.x >> p.y;
    }
};

using P = PointT<lint>;

bool onSegment(P s, P e, P p) {
    return p.cross(s, e) == 0 && (s - p).dot(e - p) <= 0;
}

bool segInter(P a, P b, P c, P d) {
    auto oa = c.cross(d, a), ob = c.cross(d, b),
            oc = a.cross(b, c), od = a.cross(b, d);
    if (sgn(oa) * sgn(ob) < 0 && sgn(oc) * sgn(od) < 0)
        return true;
    return onSegment(c, d, a) || onSegment(c, d, b) || onSegment(a, b, c) || (onSegment(a, b, d));
}

int dfs(const vector<vi>& adj, vector<int>& used, int u, int p) {
    used[u] = 1;

    int cnt = 0;
    for (auto v: adj[u]) {
        if (used[v] == 1 && v != p) {
            cnt += 1;
        } else if (used[v] == 0) {
            cnt += dfs(adj, used, v, u);
        }
    }

    used[u] = 2;
    return cnt;
}

void solve() {
    int n;
    cin >> n;

    vector<pair<P, P>> segs(n);
    for (int i = 0; i < n; i++) cin >> segs[i].first >> segs[i].second;

    vector<bitset<4000>> g(n);
    vector<vi> adj(n);
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (segInter(segs[i].first, segs[i].second, segs[j].first, segs[j].second)) {
                adj[i].push_back(j);
                adj[j].push_back(i);
            }
        }
    }

    int cnt = 0;
    vector<int> used(n);
    for (int i = 0; i < n; i++) {
        if (!used[i]) {
            cnt += dfs(adj, used, i, -1);
        }
    }
    cout << cnt + 1 << '\n';
}

int main() {
    cin.tie(nullptr)->exceptions(ios::failbit);
    ios::sync_with_stdio(false);

    int tt;
    cin >> tt;

    while (tt--) {
        solve();
    }
}
